local f = CreateFrame("StatusBar", "THM_Frame",UIParent)

f:RegisterEvent("UNIT_POWER_UPDATE")
f:RegisterEvent("ADDON_LOADED")
f:SetScript("OnEvent", function (self, event, arg1)
	if event == "ADDON_LOADED" and arg1 == "DC-TotalHealerMana" then
		onLoad()
		if DC_TotalHealerMana == nil then
			DC_TotalHealerMana = {}
			DC_TotalHealerMana.full = false
		end
	elseif event == "UNIT_POWER_UPDATE" then
		f.title:SetText(updateData())
	end
end)

f:SetMovable(true)
f:EnableMouse(true)
f:RegisterForDrag("RightButton")
f:SetScript("OnDragStart", f.StartMoving)
f:SetScript("OnDragStop", f.StopMovingOrSizing)
	
local blacklist = {};

function getIndex(t, v)
	local i = 1;
	
	while t[i] do
		if (v == t[i]) then
			return i;
		end
		i = i + 1
	end
	
	return 0;
end

function blacklistPlayer(player)
	local index = getIndex(blacklist, player)
	if (index > 0) then
		table.remove(blacklist, index)
		DEFAULT_CHAT_FRAME:AddMessage("|cff00D1FFTHM:|r " .. player .. " no longer blacklisted")
	else
		table.insert(blacklist, player)
		DEFAULT_CHAT_FRAME:AddMessage("|cff00D1FFTHM:|r " .. player .. " blacklisted")
	end
end

function updateData(msg)
	if IsInRaid() then
		local players = GetNumGroupMembers()

		local total, totalMax = 0, 0
		for groupindex = 1,players do
			if not tContains(blacklist, GetUnitName("raid"..groupindex)) then
				local id = select(3, UnitClass("raid"..groupindex))
				if (id == 2 or id == 5 or id == 11 or id == 7) then
					total = total + UnitPower("raid"..groupindex,0)
					totalMax = totalMax + UnitPowerMax("raid"..groupindex,0)
				end
			end
		end
	
		local output = string.format("%.0f%%", (100*(total/totalMax)))
		if DC_TotalHealerMana.full then
			output = output .. string.format(" - %d/%d", total, totalMax)
		end
		
		if not f:IsShown() and totalMax > 0 then
			f:Show()
		end
		
		f:SetMinMaxValues(0, totalMax)
		f:SetValue(total)
		
		return output
	elseif IsInGroup() then
		local players = GetNumGroupMembers()

		local total, totalMax = 0, 0
		for groupindex = 1,players do
			if not tContains(blacklist, GetUnitName("party"..groupindex)) then
				local id = select(3, UnitClass("party"..groupindex))
				if (id == 2 or id == 5 or id == 11 or id == 7) then
					total = total + UnitPower("party"..groupindex,0)
					totalMax = totalMax + UnitPowerMax("party"..groupindex,0)
				end
			end
		end
		
		if not tContains(blacklist, GetUnitName("player")) then
			local id = select(3, UnitClass("player"))
			if (id == 2 or id == 5 or id == 11 or id == 7) then
				total = total + UnitPower("player",0);
				totalMax = totalMax + UnitPowerMax("player",0);
			end
		end
	
		local output = string.format("%.0f%%", (100*(total/totalMax)))
		if DC_TotalHealerMana.full then
			output = output .. string.format(" - %d/%d", total, totalMax)
		end
		
		if not f:IsShown() and totalMax > 0 then
			f:Show()
		end
		
		f:SetMinMaxValues(0, totalMax)
		f:SetValue(total)
		
		return output
	end
	
	if f:IsShown() then
		f:Hide()
	end
	return ""
end

function firstUpper(str)
	return string.upper(str:sub(1,1))..string.lower(str:sub(2))
end

function thm(msg)
	local msg_split = {}
	for v in string.gmatch(msg, "[^ ]+") do
		table.insert(msg_split, v)
	end
	
	if msg_split[1] == "toggle" then
		DC_TotalHealerMana.full = not DC_TotalHealerMana.full
	elseif msg_split[1] == "bl" then
		blacklistPlayer(firstUpper(msg_split[2]))
	else 
		local output = updateData()
		if (#output ~= 0) then
			output = "Healers total mana: "..output
			if msg_split[1] == "p" then
				SendChatMessage(output, "PARTY")
			elseif msg_split[1] == "r" then
				SendChatMessage(output, "RAID")	
			elseif msg_split[1] == "rw" then
				SendChatMessage(output, "RAID_WARNING")
			else
				f.title:SetText(output)
			end
		else
			DEFAULT_CHAT_FRAME:AddMessage("|cff00D1FFTHM:|r You need to be in a raid group")
		end
	end
end

function onLoad()
	SLASH_THM1 = '/thm'
	SlashCmdList["THM"] = thm
	
	f:SetMovable(true)
	f:EnableMouse(true)
	f:RegisterForDrag("RightButton")
	f:SetScript("OnDragStart", f.StartMoving)
	f:SetScript("OnDragStop", f.StopMovingOrSizing)

	f:SetPoint("CENTER",0,0)
	f:SetSize(200,20)
	--statusbar background
	f.bg = f:CreateTexture(nil,"BACKGROUND",nil,-8)
	f.bg:SetAllPoints(f)
	f.bg:SetColorTexture(0/255,191/255,255/255)
	f.bg:SetAlpha(0.2)
	--statusbar texture
	local tex = f:CreateTexture(nil,"BACKGROUND",nil,-6)
	tex:SetColorTexture(0/255,191/255,255/255)
	f:SetStatusBarTexture(tex)
	f:SetStatusBarColor(0/255,191/255,255/255)
	f:SetAlpha(0.8)
	--values
	f:SetMinMaxValues(0, 0)
	f:SetValue(0)
	
	f:SetFrameStrata("BACKGROUND")
	
	f.title = f:CreateFontString(nil, "OVERLAY")
	f.title:SetFontObject("GameFontHighlight", 24)
	f.title:SetPoint("CENTER", f, "CENTER", 0, 0)

	f:SetPoint("CENTER",0,0)
	f:Hide()
end
